<?php

namespace Inside\Authentication\Facades;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Facade;
use Inside\Authentication\Contracts\Authentication as AuthenticationContract;
use Inside\Authentication\Models\User;

/**
 * @method static \Inside\Authentication\AccessToken login(array $credentials, bool $remember = false)
 * @method static void validate(array $credentials)
 * @method static \Inside\Authentication\AccessToken logAs(\Inside\Authentication\Models\User $user, string $authenticator, bool $force = false, bool $remember = false)
 * @method static bool setUserToMagicCookie(\Illuminate\Http\Request $request, \Inside\Authentication\Models\User $user, string $token, bool $force = false, bool $remember = false)
 * @method static \Inside\Authentication\Models\User|null getUserFromMagicCookie(Request $request)
 * @method static void invalidateUserFromMagicCookie()
 * @method static string encryptToken(string $token)
 * @method static \Inside\Authentication\Models\User|null logout(\Inside\Authentication\Models\User|null $user = null)
 * @method static void  kickUser(\Inside\Authentication\Models\User $user, string|null $reason = null)
 * @method static void  kickAll(string|null $reason = null)
 * @method static bool hasMagicCookie(\Illuminate\Http\Request $request)
 * @method static bool checkExternalJWTToken(string|null $application = null)
 */
class Authentication extends Facade
{
    protected static function getFacadeAccessor(): string
    {
        return AuthenticationContract::class;
    }
}
