<?php

namespace Inside\Authentication\Exceptions;

use Illuminate\Auth\AuthenticationException as BaseAuthenticationException;
use Symfony\Component\HttpKernel\Exception\HttpExceptionInterface;

/**
 * Class AuthenticationException
 */
class AuthenticationException extends BaseAuthenticationException implements HttpExceptionInterface
{
    /**
     * AuthenticationException constructor.
     */
    public function __construct(
        string $message = 'Unauthenticated.',
        array $guards = [],
        protected ?string $link = null,
        protected ?string $linkTitle = null
    ) {
        parent::__construct($message, $guards);
    }

    /**
     * Does this authentication exception has a link?
     */
    public function hasLink(): bool
    {
        return $this->link !== null;
    }

    /**
     * Get link when getting a 401
     */
    public function getLink(): ?string
    {
        return $this->link;
    }

    /**
     * get link title
     */
    public function getLinkTitle(): ?string
    {
        return $this->linkTitle;
    }

    public function getStatusCode(): int
    {
        return 401;
    }

    public function getHeaders(): array
    {
        return [];
    }
}
