<?php

namespace Inside\Authentication\Events;

use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PresenceChannel;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcastNow;
use Illuminate\Queue\SerializesModels;
use Inside\Authentication\Models\Token;
use Inside\Authentication\Models\User;
use Inside\Events\Dispatchable;

class UserHasBeenDisconnectedEvent implements ShouldBroadcastNow
{
    use InteractsWithSockets;
    use SerializesModels;
    use Dispatchable;

    /**
     * User has been disconnected
     */
    public function __construct(
        public User $user,
        public?string $reason
    ) {
    }

    /**
     * Get the channels the event should broadcast on.
     */
    public function broadcastOn(): array
    {
        return [
            new PresenceChannel('inside.users'),
            new PrivateChannel('inside.'.$this->user->uuid),
        ];
    }

    public function broadcastAs(): string
    {
        return 'inside_user.disconnected';
    }
}
