<?php

declare(strict_types=1);

namespace Inside\Authentication\Contracts;

use Illuminate\Http\Request;
use Inside\Authentication\AccessToken;
use Inside\Authentication\Models\User;

interface Authentication
{
    public function login(array $credentials, bool $remember = false): AccessToken;

    public function validate(array $credentials): void;

    public function logAs(User $user, string $authenticator, bool $force = false, bool $remember = false): AccessToken;

    public function setUserToMagicCookie(
        Request $request,
        User $user,
        string $token,
        bool $force = false,
        bool $remember = false
    ): bool;

    public function getUserFromMagicCookie(Request $request): ?User;

    public function updateMagieCookieLifetime(Request $request): bool;

    public function invalidateUserFromMagicCookie(): void;

    public function encryptToken(string $token): string;

    public function logout(?User $user = null): ?User;

    public function kickUser(User $user, ?string $reason = null): void;

    public function kickAll(?string $reason = null): void;

    public function hasMagicCookie(Request $request): bool;

    public function checkExternalJWTToken(?string $application = null): bool;
}
