<?php

namespace Inside\Authentication\Console;

use Illuminate\Console\Command;
use Inside\Authentication\Jobs\TokensCleanup;

/**
 * Command to dispatch Tokens Cleanup job
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class TokensCleanupCommand extends Command
{
    /**
     * @var string
     */
    protected $name = 'inside:authentication:cleanup';

    /**
     * @var string
     */
    protected $description = 'Clean up tokens';

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'inside:authentication:cleanup';

    /**
     * @inheritDoc
     */
    public function handle(): void
    {
        TokensCleanup::dispatch();
    }
}
