<?php

namespace Inside\Authentication\Console;

use Illuminate\Database\Eloquent\ModelNotFoundException;
use Inside\Authentication\Models\ApplicationClient;
use Inside\Console\Command;
use Tymon\JWTAuth\Claims\Factory;
use Tymon\JWTAuth\Facades\JWTAuth;
use Tymon\JWTAuth\Validators\PayloadValidator;

class GenerateApplicationTokenCommand extends Command
{
    protected $signature = 'inside:authentication:jwt {application} {--long-life}';

    protected $description = 'Création d\'un token valid pour l\'application donnée';

    public function handle(): void
    {
        /** @var string $application */
        $application = $this->argument('application');
        $longLife = (bool) $this->option('long-life');
        $this->line("Génération d'un token unique pour l'application {$application}");
        try {
            $client = ApplicationClient::where('name', $application)->firstOrFail();
        } catch (ModelNotFoundException $e) {
            $this->error("L'application {$application} n'est pas supporté par Inside pour le moment");

            return;
        }
        if ($longLife) {
            // Payload factory
            JWTAuth::factory()->setTTL(null);
            // Claim factory
            app(Factory::class)->setTTL(null);
            app(PayloadValidator::class)->setRequiredClaims([
                'iss',
                'iat',
                'nbf',
                'sub',
                'jti',
            ]);
        }
        $token = JWTAuth::fromSubject($client);
        $this->writeln("Le token pour l'application <fg=cyan>{$application}</fg=cyan> est");
        $this->writeln("<fg=green>{$token}</fg=green>");
    }
}
