<?php

namespace Inside\Authentication\Console;

use Inside\Authentication\Models\ApplicationClient;
use Inside\Console\Command;

class GenerateApplicationClientRemoveCommand extends Command
{
    protected $signature = 'inside:authentication:client:rm {application}';

    protected $description = 'Suppression d\'une application client JWT';

    public function handle(): void
    {
        /** @var string $application */
        $application = $this->argument('application');
        $this->line("Suppression de l'application {$application}");
        if (false === $this->confirm('Etes-vous sur de vouloir continuer ?')) {
            return;
        }
        $client = ApplicationClient::where('name', $application)->first();
        if ($client === null) {
            $this->error('L\'application  {$application} n\'existe pas');

            return;
        }
        $client->delete();
        $this->writeln(
            "L'application <fg=cyan>{$application}</fg=cyan> a bien été supprimée."
        );
    }
}
