<?php

namespace Inside\Authentication\Console;

use Illuminate\Support\Facades\Hash;
use Inside\Authentication\Models\ApplicationClient;
use Inside\Console\Command;
use Inside\Support\Str;

class GenerateApplicationClientAddCommand extends Command
{
    protected $signature = 'inside:authentication:client:add {application}';

    protected $description = 'Création d\'une nouvelle application client JWT';

    public function handle(): void
    {
        /** @var string|null $application */
        $application = $this->argument('application');

        $this->line("Génération de l'application {$application}");
        $client = ApplicationClient::where('name', $application)->first();
        if ($client) {
            $this->error('L\'application  {$application} existe déjà');

            return;
        }
        $client = new ApplicationClient();
        // @phpstan-ignore-next-line
        $client->name = $application;
        $secret = Str::random(64);
        $client->secret = Hash::make($secret);
        $client->type = 'external';
        $client->save();
        $this->writeln(
            "L'application <fg=cyan>{$application}</fg=cyan> a bien été créé. La clé secrète d'identification est "
        );
        $this->writeln("<fg=green>{$secret}</fg=green>");
    }
}
