<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Authentication\Facades\InsideSessionLifetime;
use Inside\Settings\Facades\Settings;
use Inside\Settings\Models\Setting;

final class AlterSessionLifetimeDefault30Days extends Migration
{
    public function up(): void
    {
        Setting::updateOrCreate(
            ['key' => 'inside_session_lifetime', 'group' => 'loginpage'],
            ['value' => intval(config('session.lifetime'))]
        );
    }
}
