<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateInsideOtpTokensTable extends Migration
{
    public function up(): void
    {
        Schema::create('inside_otp_tokens', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->uuid('user_uuid')->collate('utf8');
            $table->string('token', 6);
            $table->unique(['user_uuid', 'token']);
            $table->timestamps();
        });

        Schema::table('inside_otp_tokens', function (Blueprint $table) {
            $table->foreign('user_uuid')->references('uuid')->on('inside_users')->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::table('inside_otp_tokens', function (Blueprint $table) {
            $table->dropForeign('inside_otp_tokens_user_uuid_foreign');
        });
        Schema::drop('inside_otp_tokens');
    }
}
