<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddLoginFieldsToUsersTable extends Migration
{
    public function up(): void
    {
        if (! Schema::hasTable('inside_users')) {
            return;
        }

        if (! Schema::hasColumn('inside_users', 'last_login_at')) {
            Schema::table('inside_users', function (Blueprint $table) {
                $table->datetime('last_login_at')->nullable();
            });
        }

        if (! Schema::hasColumn('inside_users', 'last_login_ip')) {
            Schema::table('inside_users', function (Blueprint $table) {
                $table->string('last_login_ip')->nullable();
            });
        }
    }
}
