<?php

declare(strict_types=1);

use Illuminate\Support\Facades\Route;

Route::group(
    [
        'namespace' => 'Inside\Ai\Http\Controllers',
        'prefix' => 'api/v1/ai',
        'middleware' => ['auth.api'],
    ],
    function ($router) {
        $router->get('actions', ['uses' => 'AIController@getActions']);
        $router->get('config', ['uses' => 'AIController@getConfig']);
        $router->post('process', ['uses' => 'AIController@processText']);
    }
);
