<?php

namespace Inside\Ai\Http\Requests;


use Inside\Http\Requests\FormRequest;

class ProcessTextRequest extends FormRequest
{

    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'text' => [
                'required',
                'string',
                'max:10000',
                'min:1'
            ],
            'action' => [
                'required',
                'string',
                'in:' . implode(',', array_keys(config('ai.prompts.actions', [])))
            ]
        ];
    }
}
