<?php

namespace Inside\Ai\DTO;

class TextProcessingResult
{
    private function __construct(
        public readonly string $originalText,
        public readonly string $processedText,
        public readonly string $action,
        public readonly bool $success,
        public readonly ?string $error = null,
        public readonly array $metadata = []
    ) {}

    public static function success(
        string $originalText,
        string $processedText,
        string $action,
        array $metadata = []
    ): self {
        return new self(
            originalText: $originalText,
            processedText: $processedText,
            action: $action,
            success: true,
            metadata: $metadata
        );
    }

    public static function failure(
        string $originalText,
        string $action,
        string $error,
        array $metadata = []
    ): self {
        return new self(
            originalText: $originalText,
            processedText: '',
            action: $action,
            success: false,
            error: $error,
            metadata: $metadata
        );
    }

    public function toArray(): array
    {
        return [
            'original_text' => $this->originalText,
            'processed_text' => $this->processedText,
            'action' => $this->action,
            'success' => $this->success,
            'error' => $this->error,
            'metadata' => $this->metadata,
        ];
    }
}
