<?php

namespace Inside\Ai\DTO;

class AIResponse
{
    private function __construct(
        public readonly string $processedText,
        public readonly bool $success,
        public readonly ?string $error = null,
        public readonly array $metadata = []
    ) {}

    public static function success(
        string $processedText,
        array $metadata = []
    ): self {
        return new self(
            processedText: $processedText,
            success: true,
            metadata: $metadata
        );
    }

    public static function failure(string $error, array $metadata = []): self
    {
        return new self(
            processedText: '',
            success: false,
            error: $error,
            metadata: $metadata
        );
    }
}
