<?php

namespace Inside\User\Validators;

use Illuminate\Validation\Rule;
use Illuminate\Validation\ValidationException;

class UserValidator extends BaseValidator
{
    /**
     * @param array $data
     * @return void
     * @throws ValidationException
     */
    public function create(array $data): void
    {
        $rules = array_only(
            $this->rules(),
            [
                'name',
                'email',
                'password',
            ]
        );
        $this->validate($data, $rules);
    }

    /**
     * List user validator rules.
     *
     * @param string|null $uuid
     * @return array
     */
    protected function rules(string $uuid = null): array
    {
        $unique = Rule::unique('inside_users')->ignore($uuid);

        return [
            'name'     => ['bail', 'required', 'min:3', 'max:255', $unique],
            'email'    => ['required', 'email'/*, 'unique:user'*/],
            'password' => ['required', 'min:8'/*, 'confirmed'*/],
        ];
    }

    /**
     * Validate user input on update.
     *
     * @param string $uuid
     * @param array  $data
     * @return void
     */
    public function update(string $uuid, array $data): void
    {
        $rules = array_only(
            $this->rules($uuid),
            [
                'name',
                'email',
                'password',
            ]
        );

        foreach ($rules as $attribute => $rule) {
            if (! isset($data[$attribute])) {
                unset($rules[$attribute]);
            }
        }
        $this->validate($data, $rules);
    }
}
