<?php

namespace Inside\User\Validators;

use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\ValidationException;

class BaseValidator
{
    /**
     * @param mixed $data
     * @param array $rules
     * @return void
     * @throws ValidationException
     */
    public function validate($data, array $rules = []): void
    {
        $validator = Validator::make($data, $rules);
        if ($validator->fails()) {
            throw new ValidationException($validator);
        }
    }
}
