<?php

namespace Inside\User\Notifications;

use Illuminate\Auth\Notifications\ResetPassword;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Support\Facades\Lang;
use Inside\Content\Models\Contents\Users;

class CreatePasswordNotification extends ResetPassword
{
    /**
     * @var string
     */
    public $email;

    public function __construct(string $token, string $email)
    {
        parent::__construct($token);

        $this->email = $email;
    }

    /**
     * @param mixed $notifiable
     * @return MailMessage
     */
    public function toMail($notifiable)
    {
        Lang::setLocale($notifiable->langcode);
        $user = Users::find($notifiable->uuid);
        $data = [
            'expire' => config('auth.passwords.users_welcome.expire'),
            'url' => config('app.url'),
            'fullname' => trim($user->firstname.' '.$user->lastname),
            'sitename' => env('APP_NAME'),
        ];
        $lines = explode("\n", Lang::get('mail.password_create.main_text', $data));
        $message = (new MailMessage())->subject(Lang::get('mail.password_create.subject', $data));

        foreach ($lines as $line) {
            $message->line($line);
        }

        $message->action(
            Lang::get('mail.password_create.button_text', $data),
            url(config('app.url').'/password/create?token='.$this->token.'&email='.$this->email)
        )->greeting(
            Lang::get('mail.password_create.greeting', $data)
        )->markdown('emails.notification');

        return $message;
    }
}
