<?php

namespace Inside\User\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Inside\Content\Events\ContentUpdatingEvent;
use Inside\Content\Models\Contents\Users;
use Inside\Notify\Listeners\BaseNotificationListener;
use Inside\User\Jobs\DisableUserJob;
use Inside\User\Jobs\EnableUserJob;

/**
 * Handle default shortcuts for new users
 *
 * @category Class
 * @author   Maxime Jacquot <maxime.jacquot@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class UserUpdatingListener extends BaseNotificationListener implements ShouldQueue
{
    /**
     * @inheritDoc
     * @param ContentUpdatingEvent $event
     * @return void
     */
    public function handle(ContentUpdatingEvent $event)
    {
        $model = $event->model;

        if (! $model instanceof Users || ! $model->isDirty('status')) {
            return;
        }

        $model->status ? EnableUserJob::dispatch($model->uuid) : DisableUserJob::dispatch($model->uuid);
    }
}
