<?php

namespace Inside\User\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Inside\Authentication\Events\UserUndecisionized;
use Inside\User\Jobs\EnableUserJob;

class UndecisionizeUser implements ShouldQueue
{
    /**
     * @param UserUndecisionized $event
     * @return void
     */
    public function handle(UserUndecisionized $event)
    {
        EnableUserJob::dispatch($event->getUserUuid());
    }
}
