<?php

namespace Inside\User\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Password;
use Illuminate\Support\Facades\Schema;
use Inside\Authentication\Models\User as AuthenticationUser;
use Inside\Jobs\Bus\Dispatchable;
use Inside\User\Models\User;

class SendCreatePasswordMail implements ShouldQueue
{
    use Dispatchable;
    use InteractsWithQueue;
    use Queueable;

    /**
     * @var string
     */
    private $userUuid;

    /**
     * @var string
     */
    protected $tempTableName = 'inside_temp_password_mails_sent';

    public function __construct(string $userUuid)
    {
        $this->userUuid = $userUuid;
    }

    /**
     * @return void
     */
    public function handle()
    {
        if (! $this->userUuid) {
            return;
        }

        if (Schema::hasTable($this->tempTableName) && DB::table($this->tempTableName)->where('user_uuid', $this->userUuid)->exists()) {
            return;
        }

        $user = User::find($this->userUuid);

        if (! $user) {
            return;
        }

        Password::broker('users_welcome')->sendResetLink(['email' => $user->email], function ($user, $token) {
            $user = AuthenticationUser::find($user->uuid);

            /** @var AuthenticationUser $user */
            $user->sendPasswordCreateNotification($token);
        });

        if (Schema::hasTable($this->tempTableName)) {
            DB::table($this->tempTableName)->insert([
                'date_sent' => date('Y-m-d H:i:s'),
                'user_uuid' => $this->userUuid,
            ]);
        }
    }
}
