<?php

namespace Inside\User\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Support\Facades\Log;
use Inside\Jobs\Bus\Dispatchable;
use Inside\User\Events\UserEnabledEvent;
use Inside\User\Models\User;

class EnableUserJob implements ShouldQueue
{
    use Dispatchable;
    use InteractsWithQueue;
    use Queueable;

    /**
     * @var string
     */
    private $userUuid;

    /**
     * @param string $userUuid
     */
    public function __construct(string $userUuid)
    {
        $this->userUuid = $userUuid;
    }

    /**
     * @return void
     */
    public function handle()
    {
        $user = User::find($this->userUuid);
        if ($user === null || $user->permission === null) {
            return;
        }

        // if decommissioning not activated
        if (! config('users.decommissioning', false)) {
            return;
        }

        if ($user->permission->hasAnyRole(
            array_unique(array_merge(['super_administrator'], config('users.roles_whitelist')))
        )
        ) {
            Log::warning(
                '[inside-user] Utilisateur <'.$user->uuid
                .'> ne peut être décommissionné car il appartient à un role whitelisted.'
            );

            return;
        }
        Log::info('[inside-user] Utilisateur <'.$user->uuid.'> va être recommissionné.');
        UserEnabledEvent::dispatch($user->uuid);
    }
}
