<?php

namespace Inside\User\Http\Controllers;

use Laravel\Lumen\Routing\Controller as BaseController;
use League\Fractal;

class Controller extends BaseController
{
    /**
     * @param mixed $items
     * @param Fractal\TransformerAbstract $transformer
     * @return array
     */
    public function collection($items, Fractal\TransformerAbstract $transformer): array
    {
        $resource = new Fractal\Resource\Collection($items, $transformer);

        return $this->resource($resource);
    }

    /**
     * @param Fractal\Resource\ResourceAbstract $resource
     * @return array
     */
    protected function resource(Fractal\Resource\ResourceAbstract $resource): array
    {
        $fractal = new Fractal\Manager();

        return $fractal->createData($resource)->toArray();
    }

    /**
     * @param mixed $item
     * @param Fractal\TransformerAbstract $transformer
     * @return array
     */
    public function item($item, Fractal\TransformerAbstract $transformer): array
    {
        $resource = new Fractal\Resource\Item($item, $transformer);

        return $this->resource($resource);
    }
}
