<?php

namespace Inside\User\Console;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Inside\Content\Facades\Schema;
use Inside\Content\Models\Contents\Sites;
use Inside\Host\Bridge\BridgeContent;

class CleanUserReferences extends Command
{
    /**
     * @var string
     */
    protected $name = 'inside:user:clean-references';

    /**
     * @var string
     */
    protected $signature = 'inside:user:clean-references {content_types}';

    /**
     * @var string
     */
    protected $description = 'Clean user references';

    /**
     * @return void
     */
    public function handle()
    {
        /** @var string $types */
        $types = $this->argument('content_types');
        $contentTypes = explode(',', $types);
        $bridge = new BridgeContent();
        $languages = list_languages();
        $this->info('Cleaning '.implode(',', $contentTypes));

        foreach ($contentTypes as $contentType) {
            if (! Schema::hasContentType($contentType)) {
                continue;
            }
            $contents = call_user_func(type_to_class($contentType).'::all');

            if ($contents->count() === 0) {
                continue;
            }

            foreach ($contents as $content) {
                foreach ($languages as $language) {
                    $translation = $content->getTranslationIfExists($language);
                    $pivots = DB::table('inside_pivots')
                        ->where('related_uuid', $translation->uuid)
                        ->where('parent_type', type_to_class('users'))
                        ->get();

                    if ($pivots->count() > 0) {
                        foreach ($pivots as $pivot) {
                            $user = DB::table('inside_content_users')->where('uuid', $pivot->parent_uuid)->first();
                            if (
                                $user !== null
                                && (property_exists($user, 'status') && $user->status)
                                && (property_exists($user, 'is_maintenance') && ! $user->is_maintenance)) {
                                continue 3;
                            }
                        }
                    }
                }
                $this->info(sprintf('Deleting %s %s [uuid: %s]', $contentType, $content->title, $content->uuid));
                $bridge->contentDelete($contentType, $content->uuid);
            }
        }
    }
}
