<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\DynamicClass;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

class AddSendMailFieldToUsers extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        DynamicClass::disableRebuildAutoLoad();
        $this->bootUp(__FILE__, 'Add send_mail field');

        $this->bridge->contentTypeCreateOrUpdateField('users', 'send_mail', [
            'name' => 'send_mail',
            'searchable' => false,
            'search_filter' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'default' => false,
            'weight' => 0,
            'title' => [
                'fr' => 'Envoyer un mail de création de mot de passe',
                'en' => 'Send password creation mail',
            ],
            'widget' => [
                'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [
                    'display_label' => true,
                ],
                'weight' => 0,
            ],
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ]);

        $this->finishUp();
        DynamicClass::enableRebuildAutoLoad();
        $this->call('models:rebuild');
    }

    public function down(): void
    {
        $this->bootDown(__FILE__);
        $this->finishDown();
    }
}
