<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateContentUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('inside_content_users', function (Blueprint $table) {
            $table->uuid('uuid')->collate('utf8');
            $table->uuid('uuid_host')->collate('utf8');
            $table->tinyInteger('status')->default(0);
            $table->uuid('author')->collate('utf8')->nullable();
            $table->string('name', 255);
            $table->string('email', 255);
            $table->char('langcode', 2)->nullable();
            $table->uuid('pid')->collate('utf8');
            $table->timestamps();
            $table->primary('uuid');
            $table->index('email');
            $table->index('name');
            $table->index('pid');
            $table->index(['uuid', 'langcode']);
            $table->foreign('uuid')
                ->references('uuid')->on('inside_users')
                ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('inside_content_users');
    }
}
