<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('inside_users', function (Blueprint $table) {
            $table->uuid('uuid')->collate('utf8');
            $table->uuid('uuid_host')->collate('utf8');
            $table->string('name', 255)->unique()->nullable();
            $table->string('email', 255)->unique()->nullable();
            $table->string('password', 255);
            $table->tinyInteger('status')->default(0);
            $table->char('langcode', 2)->nullable();
            $table->string('api_token', 60)->nullable();
            $table->rememberToken();
            $table->timestamps();
            $table->primary('uuid');
            $table->index('uuid');
            $table->index('name');
            $table->index('email');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('inside_users');
    }
}
