<?php

use Illuminate\Support\Facades\Route;
use Inside\Routing\Router;

Route::group(
    [
        'namespace' => 'Inside\Import\Http\Controllers',
        'prefix' => 'api/v1/admin',
        'middleware' => 'super_admin',
    ],
    function (Router $router) {
        $router->get('users/imports/latest', ['uses' => 'UsersImportController@latest']);
        $router->get('users/imports/providers', ['uses' => 'UsersImportController@getProviders']);
        $router->get('users/imports/dump/{provider}', ['uses' => 'UsersImportController@getUserFromAD']);
        $router->get('users/import', ['uses' => 'UsersImportController@listUserImportScheduleCommands']);
        $router->post('users/import/{commandName}', ['uses' => 'UsersImportController@runUsersImport']);
    }
);
