<?php

namespace Inside\Import\Providers;

use Illuminate\Container\Container;
use Illuminate\Filesystem\Filesystem;
use Illuminate\Support\ServiceProvider;
use Inside\Import\Console\DumpCommand;
use Inside\Import\Console\ImportCommand;
use Inside\Import\Console\SyncroMakeCommand;
use Inside\Import\Events\ImportFailedEvent;
use Inside\Import\Events\ImportFinishedEvent;
use Inside\Import\Listeners\ImportFailedListener;
use Inside\Import\Listeners\ImportFinishedListener;
use Inside\Import\Services\UserImportService;
use Inside\Support\EventServiceProvider;

/**
 * Inside package user import service.
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class UserImportServiceProvider extends EventServiceProvider
{
    public array $singletons = [
        UserImportService::class => UserImportService::class,
    ];

    protected array $commands = [
        ImportCommand::class,
        DumpCommand::class,
    ];

    protected array $listen = [
        ImportFinishedEvent::class => [
            ImportFinishedListener::class,
        ],
        ImportFailedEvent::class => [
            ImportFailedListener::class,
        ],
    ];

    public function register(): void
    {
        $this->mergeConfigFrom(
            __DIR__.'/../../config/user_references.php',
            'user_references'
        );
        if ($this->app->runningInConsole()) {
            $this->app->singleton(
                'command.inside.make.syncro',
                function () {
                    return new SyncroMakeCommand(new Filesystem());
                }
            );
            $this->commands('command.inside.make.syncro');
        }
    }
}
