<?php

namespace Inside\Import\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Carbon;
use Inside\Database\Eloquent\Builder;

/**
 * @property int $id
 * @property string $provider_type
 * @property int $users_found
 * @property int $users_imported
 * @property int $users_disabled
 * @property int $created_at
 * @property int $updated_at
 * @method static static create(mixed[] $attributes = [])
 * @method static Builder latest($column = null)
 */
class UsersImport extends Model
{
    protected $table = 'inside_users_imports';

    protected $casts = [
        'created_at' => 'timestamp',
        'updated_at' => 'timestamp',
    ];

    protected $fillable = [
        'provider_type',
        'users_found',
        'users_imported',
        'users_disabled',
    ];
}
