<?php

namespace Inside\Import\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Inside\Authentication\Models\User;

/**
 * Class UserReference
 *
 * @property int $id
 * @property string $provider_type
 * @property string $provider_name
 * @property string $user_id
 * @property string $reference
 * @property-read User $user
 * @method static \Illuminate\Database\Eloquent\Builder|UserReference newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|UserReference newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|UserReference query()
 * @method static \Illuminate\Database\Eloquent\Builder|UserReference whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|UserReference whereProviderName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|UserReference whereProviderType($value)
 * @method static \Illuminate\Database\Eloquent\Builder|UserReference whereReference($value)
 * @method static \Illuminate\Database\Eloquent\Builder|UserReference whereUserId($value)
 * @method static \Illuminate\Database\Eloquent\Builder where($column, $operator = null, $value = null, $boolean = 'and')
 *
 * @mixin \Eloquent
 */
class UserReference extends Model
{
    protected $table = 'inside_user_provider_references';

    public $timestamps = false;

    /**
     * @return BelongsTo
     */
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'user_id', 'uuid');
    }
}
