<?php

namespace Inside\Import\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Support\Facades\Artisan;
use Inside\Import\Events\ImportFinishedEvent;
use Inside\Notify\Listeners\BaseNotificationListener;
use Inside\Notify\Models\NotificationType;

class ImportFinishedListener extends BaseNotificationListener implements ShouldQueue
{
    public function handle(ImportFinishedEvent $event): void
    {
        /** @var NotificationType $notificationType */
        $notificationType = NotificationType::where([
            'event' => 'Inside\Import\Events\ImportFinishedEvent',
            'action' => 'import',
        ])->first();

        $user = $event->uploader;
        $this->route = $user;
        $this->notify($notificationType, $user, null, [
            'total' => $event->usersFound,
            'imported' => $event->importedUsers,
            'disabled' => $event->disabledUsers,
        ]);
    }
}
