<?php

namespace Inside\Import\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Inside\Import\Events\ImportFailedEvent;
use Inside\Notify\Listeners\BaseNotificationListener;
use Inside\Notify\Models\NotificationType;

class ImportFailedListener extends BaseNotificationListener implements ShouldQueue
{
    public function handle(ImportFailedEvent $event): void
    {
        /** @var NotificationType $notificationType */
        $notificationType = NotificationType::where([
            'event' => 'Inside\Import\Events\ImportFailedEvent',
            'action' => 'import',
        ])->first();

        $user = $event->uploader;

        $this->route = $user;
        $this->notify($notificationType, $user, null, [
            'errorMessage' => str_replace(':', ' ', $event->errorMessage),
        ]);
    }
}
