<?php

namespace Inside\Import\Events;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;
use Inside\Authentication\Models\User;
use Inside\CSV\Events\ImportFinishedEvent;
use Symfony\Component\Process\Exception\ProcessFailedException;
use Symfony\Component\Process\Process;

class RunUserImportCommand implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected string $command;

    protected ?User $user;

    public function __construct(string $command, ?User $user)
    {
        $this->command = $command;
        $this->user = $user;
    }

    public function handle(): void
    {
        try {
            $cmd = sprintf('php artisan %s --notify-user=%s', $this->command, $this->user->uuid);
            $process = Process::fromShellCommandline($cmd);

            $process->run();

            if (! $process->isSuccessful()) {
                throw new ProcessFailedException($process);
            }
        } catch (\Throwable $e) {
            Log::error('[Event] RunUserImportCommand '.$e->getMessage());
        }
    }
}
