<?php

namespace Inside\Import\Events;

use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Queue\SerializesModels;
use Inside\Authentication\Models\User;

class ImportFailedEvent implements ShouldBroadcast
{
    use InteractsWithSockets;
    use SerializesModels;

    /** @var string * */
    public $errorMessage;

    /** @var mixed */
    public $uploader;

    /**
     * @param string $errorMessage
     * @param User|null $uploader
     */
    public function __construct(string $errorMessage, ?User $uploader)
    {
        $this->errorMessage = $errorMessage;
        $this->uploader = $uploader;
    }

    public function broadcastOn(): Channel
    {
        return new Channel('inside');
    }
}
