<?php

namespace Inside\Import\Events;

use Inside\Events\Dispatchable;

/**
 * Called before a user is imported
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class BeforeUserImport
{
    use Dispatchable;

    /**
     * Data that will be used to import the user
     *
     * @var array
     */
    protected $data = [];

    /**
     * BeforeUserImport constructor.
     *
     * @param mixed $data
     */
    public function __construct($data)
    {
        $this->data = $data;
    }

    /**
     * Get the data to be used for importation
     *
     * @return array
     */
    public function getData(): array
    {
        return $this->data;
    }
}
