<?php

namespace Inside\Import\Events;

use Inside\Content\Models\Contents\Users;
use Inside\Events\Dispatchable;

/**
 * Called after a user is imported
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class AfterUserImport
{
    use Dispatchable;

    /**
     * The user imported
     *
     * @var Users
     */
    protected $user = null;

    /**
     * If the user is a creation ?
     *
     * @var bool
     */
    protected $creation = false;

    /**
     * AfterUserImport constructor.
     *
     * @param Users $user
     * @param bool                                  $creation
     */
    public function __construct(Users $user, bool $creation)
    {
        $this->user = $user;
        $this->creation = $creation;
    }

    /**
     * Get the user imported
     *
     * @return Users
     */
    public function getUser(): Users
    {
        return $this->user;
    }

    /**
     * Is the user imported a creation ?
     *
     * @return bool
     */
    public function isCreation(): bool
    {
        return $this->creation;
    }
}
