<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Notify\Models\NotificationSubscriber;
use Inside\Notify\Models\NotificationType;
use Inside\User\Models\User;

class AddImportFinishedNotificationType extends Migration
{
    public function up(): void
    {
        /** @var ?NotificationType $notificationType */
        $notificationType = NotificationType::firstOrCreate(
            [
                'via' => 'web',
                'default' => true,
                'event' => 'Inside\Import\Events\ImportFinishedEvent',
                'model' => '',
                'action' => 'import',
                'type' => 'system',
                'condition' => '',
                'multiple' => false,
                'profile' => false,
                'data' => [
                    'title' => 'notifications.import.finished.title',
                    'description' => 'notifications.import.finished.description',
                    'text' => 'notifications.import.finished.text',
                ],
            ]
        );

        if ($notificationType) {
            User::all()->each(function ($user) use ($notificationType) {
                NotificationSubscriber::firstOrCreate(
                    [
                        'user_uuid' => $user->uuid,
                        'notification_type_id' => $notificationType->id,
                    ]
                );
            });
        }
    }
}
