<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Notify\Models\NotificationSubscriber;
use Inside\Notify\Models\NotificationType;
use Inside\User\Models\User;

class AddImportFailedNotificationType extends Migration
{
    public function up(): void
    {
        /** @var ?NotificationType $notificationType */
        $notificationType = NotificationType::firstOrCreate(
            [
                'via' => 'web',
                'default' => true,
                'event' => 'Inside\Import\Events\ImportFailedEvent',
                'model' => '',
                'action' => 'import',
                'type' => 'system',
                'condition' => '',
                'multiple' => false,
                'profile' => false,
                'data' => [
                    'title' => 'notifications.import.failed.title',
                    'description' => 'notifications.import.failed.description',
                    'text' => 'notifications.import.failed.text',
                ],
            ]
        );

        if ($notificationType) {
            User::all()->each(function ($user) use ($notificationType) {
                NotificationSubscriber::firstOrCreate(
                    [
                        'user_uuid' => $user->uuid,
                        'notification_type_id' => $notificationType->id,
                    ]
                );
            });
        }
    }
}
