<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

final class CreateUsersImportsTable extends Migration
{
    public function up(): void
    {
        if (Schema::hasTable('inside_users_imports')) {
            return;
        }

        Schema::create(
            'inside_users_imports',
            function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->string('provider_type', 255);
                $table->unsignedInteger('users_found');
                $table->unsignedInteger('users_imported');
                $table->unsignedInteger('users_disabled');
                $table->dateTime('created_at');
                $table->dateTime('updated_at');
            }
        );
    }

    public function down(): void
    {
        Schema::dropIfExists('inside_users_imports');
    }
}
