=<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUserProviderReferencesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        Schema::create(
            'inside_user_provider_references',
            function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->string('provider_type', 255);
                $table->string('provider_name', 255);
                $table->uuid('user_id');
                $table->string('reference');
                $table->unique(['provider_type', 'provider_name', 'user_id'], 'unique_user_by_provider');
                $table->foreign('user_id')->references('uuid')->on('inside_users')->onDelete('cascade');
            }
        );

        // Feed reference
    }

    public function down(): void
    {
        Schema::dropIfExists('inside_user_provider_references');
    }
}
