=<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddProvidersToUsers extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        Schema::table(
            'inside_users',
            function (Blueprint $table) {
                $table->string('provider_type', 255)->nullable();
                $table->string('provider_name', 255)->nullable();
            }
        );
    }

    public function down(): void
    {
        Schema::table(
            'inside_users',
            function (Blueprint $table) {
                $table->dropColumn(['provider_name', 'provider_type']);
            }
        );
    }
}
