<?php

use Illuminate\Support\Facades\Route;
use Inside\Statistics\Http\Controllers\AdvancedStatistics\AdvancedStatistics;
use Inside\Statistics\Http\Controllers\Charts\AuthenticationData;
use Inside\Statistics\Http\Controllers\Charts\GlobalChart;
use Inside\Statistics\Http\Controllers\Charts\GlobalData;
use Inside\Statistics\Http\Controllers\Charts\UserVisitChart;
use Inside\Statistics\Http\Controllers\Charts\UserVisitData;
use Inside\Statistics\Http\Controllers\Charts\VisitChart;
use Inside\Statistics\Http\Controllers\Charts\VisitData;
use Inside\Statistics\Http\Controllers\Exports\ExportAuthenticationStats;
use Inside\Statistics\Http\Controllers\Exports\ExportContentReaderStats;
use Inside\Statistics\Http\Controllers\Exports\ExportContentStats;
use Inside\Statistics\Http\Controllers\Exports\ExportUserViewedStats;
use Inside\Statistics\Http\Controllers\Exports\ExportUserVisitStats;
use Inside\Statistics\Http\Controllers\Statistics\AuthenticationStats;
use Inside\Statistics\Http\Controllers\Statistics\AuthenticationStatsBeta;
use Inside\Statistics\Http\Controllers\Statistics\ContentReadersStatsBeta;
use Inside\Statistics\Http\Controllers\Statistics\ContentStatsBeta;
use Inside\Statistics\Http\Controllers\Statistics\CountContentBeta;
use Inside\Statistics\Http\Controllers\Statistics\CountSocialBeta;
use Inside\Statistics\Http\Controllers\Statistics\ModalViewed;
use Inside\Statistics\Http\Controllers\Statistics\TypesList;
use Inside\Statistics\Http\Controllers\Statistics\UserViewedStatsBeta;
use Inside\Statistics\Http\Controllers\Statistics\UserVisitStatsBeta;

Route::group(
    [
        'prefix' => 'api/v1',
        'middleware' => 'auth.api',
    ],
    function ($router) {
        // Get types
        $router->get('statistics/types', ['uses' => TypesList::class]);

        $router->post('statistics/modal/viewed/{type}/{uuid}', ['uses' => ModalViewed::class]);
    }
);

Route::group(
    [
        'prefix' => 'api/v1',
        'middleware' => ['auth.backoffice.access:statistic'],
    ],
    function ($router) {

        // Content
        $router->get('statistics/content/{type}/{format}', ['uses' => ExportContentStats::class]);

        // Content Statistics V2
        $router->get('statistics/content/{type}', ['uses' => ContentStatsBeta::class]);
        $router->get('statistics/readers/{type}/{uuid}', ['uses' => ContentReadersStatsBeta::class]);
        $router->get('statistics/user/visits/{type}', ['uses' => UserVisitStatsBeta::class]);
        $router->get('statistics/authentication', ['uses' => AuthenticationStatsBeta::class]);
        $router->get('statistics/count/{type}', ['uses' => CountContentBeta::class]);
        $router->get('statistics/social', ['uses' => CountSocialBeta::class]);
        $router->get('statistics/user/viewed/{uuid}/{type}', ['uses' => UserViewedStatsBeta::class]);
        // End V2

        // Advanced Statistics
        $router->get('statistics/advanced/role-commitment', ['uses' => AdvancedStatistics::class.'@getRoleCommitmentStatistics']);
        $router->get('statistics/advanced/viewed-contents', ['uses' => AdvancedStatistics::class.'@getTopViewedContents']);
        $router->get('statistics/advanced/liked-contents', ['uses' => AdvancedStatistics::class.'@getTopLikedContents']);
        $router->get('statistics/advanced/viewed-categories', ['uses' => AdvancedStatistics::class.'@getTopViewedCategories']);
        $router->get('statistics/advanced/bottom-contents', ['uses' => AdvancedStatistics::class.'@getBottomContents']);
        $router->get('statistics/advanced/commented-contents', ['uses' => AdvancedStatistics::class.'@getTopCommentedContent']);
        $router->get('statistics/advanced/attendance/annual', ['uses' => AdvancedStatistics::class.'@getMonthlyAttendanceStatsByYear']);
        $router->get('statistics/advanced/roles/annual', ['uses' => AdvancedStatistics::class.'@getRoleAccessPerMonth']);
        $router->get('statistics/advanced/months', ['uses' => AdvancedStatistics::class.'@getMonths']);
        $router->get('statistics/advanced/years', ['uses' => AdvancedStatistics::class.'@getYears']);
        $router->get('statistics/advanced/engagement/annual', ['uses' => AdvancedStatistics::class.'@getYearlyGeneralStats']);
        $router->get('statistics/advanced', ['uses' => AdvancedStatistics::class.'@getStatistics']);
        // End Advanced Statistics

        // Authentication
        $router->get('statistics/authentication/{format}', ['uses' => ExportAuthenticationStats::class]);

        // Content readers
        $router->get('statistics/readers/{type}/{uuid}/{format}', ['uses' => ExportContentReaderStats::class]);

        $router->get('statistics/user/viewed/{uuid}/{type}/{format}', ['uses' => ExportUserViewedStats::class]);

        // User Visits stats
        $router->get('statistics/user/visits/{type}/{format}', ['uses' => ExportUserVisitStats::class]);

        // ##### CHARTS #####

        // Global
        $router->get('statistics/charts/global', ['uses' => GlobalChart::class]);
        $router->get(
            'statistics/charts/global/data',
            [
                'as' => 'inside.statistics.chart.global.data',
                'uses' => GlobalData::class,
            ]
        );

        // Visits
        $router->get('statistics/charts/visits', ['uses' => VisitChart::class]);
        $router->get(
            'statistics/charts/visits/data/{type}',
            [
                'as' => 'inside.statistics.chart.visits.data',
                'uses' => VisitData::class,
            ]
        );

        // Authentication
        $router->get('statistics/charts/authentications', ['uses' => AuthenticationStats::class]);
        $router->get(
            'statistics/charts/authentications/data',
            [
                'as' => 'inside.statistics.chart.authentications.data',
                'uses' => AuthenticationData::class,
            ]
        );

        // User Visits
        $router->get('statistics/charts/user/visits/{userId}', ['uses' => UserVisitChart::class]);
        $router->get(
            'statistics/charts/user/visits/data/{type}/{userId}',
            [
                'as' => 'inside.statistics.chart.user.visits.data',
                'uses' => UserVisitData::class,
            ]
        );
    }
);
