<?php

namespace Inside\Statistics\Providers;

use ConsoleTVs\Charts\Commands\ChartsCommand;
use Inside\Authentication\Events\AuthenticationLoginEvent;
use Inside\Content\Contracts\Transformer;
use Inside\Content\Events\CommentCreatedEvent;
use Inside\Reaction\Events\ReactionSubscribedEvent;
use Inside\Reaction\Events\ReactionUnsubscribedEvent;
use Inside\Statistics\Console\ComputeAdvancedStatisticsCommand;
use Inside\Statistics\Console\ComputeAuthenticationStatisticsCommand;
use Inside\Statistics\Console\ComputeContentStatisticsCommand;
use Inside\Statistics\Console\ComputeGlobalStatisticsCommand;
use Inside\Statistics\Console\ComputeUserStatisticsCommand;
use Inside\Statistics\Console\CreateStatsTables;
use Inside\Statistics\Console\MigrateStatisticsCommand;
use Inside\Statistics\Contracts\Statistic;
use Inside\Statistics\Events\AnalyticCancelLogEvent;
use Inside\Statistics\Events\AnalyticLogAuthenticationEvent;
use Inside\Statistics\Events\AnalyticLogEvent;
use Inside\Statistics\Events\AnalyticViewLogEvent;
use Inside\Statistics\Listeners\CancelLogAnalytic;
use Inside\Statistics\Listeners\CancelReactionLogAnalytic;
use Inside\Statistics\Listeners\CommentLogAnalytic;
use Inside\Statistics\Listeners\LogAnalytic;
use Inside\Statistics\Listeners\LogAuthentication;
use Inside\Statistics\Listeners\LogViewAnalytic;
use Inside\Statistics\Listeners\ReactionLogAnalytic;
use Inside\Statistics\Listeners\UserLogAnalytic;
use Inside\Statistics\Repositories\StatisticsBetaRepository;
use Inside\Statistics\Services\StatisticsService;
use Inside\Support\EventServiceProvider as ServiceProvider;
use Psr\Container\ContainerExceptionInterface;
use Psr\Container\NotFoundExceptionInterface;

class StatisticsServiceProvider extends ServiceProvider
{
    protected array $listen = [
        AnalyticLogEvent::class => [
            LogAnalytic::class,
        ],
        AnalyticViewLogEvent::class => [
            LogViewAnalytic::class,
        ],
        AnalyticLogAuthenticationEvent::class => [
            LogAuthentication::class,
        ],
        AnalyticCancelLogEvent::class => [
            CancelLogAnalytic::class,
        ],
        AuthenticationLoginEvent::class => [
            UserLogAnalytic::class,
        ],
        ReactionSubscribedEvent::class => [
            ReactionLogAnalytic::class,
        ],
        ReactionUnsubscribedEvent::class => [
            CancelReactionLogAnalytic::class,
        ],
        CommentCreatedEvent::class => [
            CommentLogAnalytic::class,
        ],
    ];

    protected array $commands = [
        ComputeContentStatisticsCommand::class,
        ComputeUserStatisticsCommand::class,
        ComputeGlobalStatisticsCommand::class,
        ComputeAuthenticationStatisticsCommand::class,
        ChartsCommand::class,
        CreateStatsTables::class,
        MigrateStatisticsCommand::class,
        ComputeAdvancedStatisticsCommand::class,
    ];

    public function boot(): void
    {
        parent::boot();

        $this->loadCharts();
    }

    protected function loadCharts(): void
    {
        $this->loadViewsFrom(cms_base_path('vendor/consoletvs/charts/src/Views'), 'charts');
        $this->mergeConfigFrom(__DIR__.'/../../config/charts.php', 'charts');
        $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/scheduler.php', 'scheduler');
    }

    public function register(): void
    {
        try {
            $this->mergeConfigFrom(__DIR__.'/../../config/statistics.php', 'statistics');
        } catch (NotFoundExceptionInterface|ContainerExceptionInterface) {
        }
        $this->app->bind(
            Statistic::class,
            function ($app) {
                $transformer = $app->make(Transformer::class);

                return new StatisticsService($app, $transformer, new StatisticsBetaRepository());
            }
        );
    }
}
