<?php

namespace Inside\Statistics\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Support\Carbon;
use Inside\Content\Models\Field;
use Inside\Content\Models\Model;
use Inside\Database\Eloquent\WithEnhancedBuilder;

/**
 * @property int $id
 * @property string $user_uuid
 * @property string $type
 * @property string $uuid
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * @property-read Collection|Field[] $fields
 * @property-read int|null $fields_count
 * @property-read mixed $model
 * @method static \Inside\Database\Eloquent\Builder|UserVisit newModelQuery()
 * @method static \Inside\Database\Eloquent\Builder|UserVisit newQuery()
 * @method static \Inside\Database\Eloquent\Builder|UserVisit query()
 * @method static Builder|UserVisit whereId($value)
 * @method static Builder|UserVisit whereType($value)
 * @method static Builder|UserVisit whereUserUuid($value)
 * @method static Builder|UserVisit whereUuid($value)
 * @method static UserVisit create(array $attributes = [])
 * @method static void truncate()
 * @method static static firstOrCreate(array $attributes, array $values = [])
 * @method static Builder|ContentVisit whereCreatedAt($value)
 * @method static Builder|ContentVisit whereUpdatedAt($value)
 *
 * @mixin Collection
 */
class UserVisit extends Model
{
    use WithEnhancedBuilder;

    /**
     * @var string
     */
    protected $table = 'user_visits';

    /**
     * @var array
     */
    protected $fillable = [
        'user_uuid',
        'uuid',
        'type',
    ];

    /**
     * @var bool
     */
    public $timestamps = true;
}
