<?php

namespace Inside\Statistics\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Inside\Authentication\Models\User;
use Inside\Content\Models\Contents\Users;
use Inside\Database\Eloquent\WithEnhancedBuilder;

/**
 * @property int $id
 * @property string $title
 * @property string $uuid
 * @property string $type
 * @property bool $status
 * @property string|null $slug
 * @property string|null $category_uuid
 * @property string|null $category_title
 * @property string|null $langcode
 * @property int $visits
 * @property int $unique_visits
 * @property int $likes
 * @property int $comments
 * @property int $created_at
 * @property int $updated_at
 * @property int $date
 * @property-read User $user
 * @method static \Inside\Database\Eloquent\Builder|ContentStatistic newModelQuery()
 * @method static \Inside\Database\Eloquent\Builder|ContentStatistic newQuery()
 * @method static \Inside\Database\Eloquent\Builder|ContentStatistic query()
 * @method static Builder|ContentStatistic whereCategoryTitle($value)
 * @method static Builder|ContentStatistic whereCategoryUuid($value)
 * @method static Builder|ContentStatistic whereComments($value)
 * @method static Builder|ContentStatistic whereCreatedAt($value)
 * @method static Builder|ContentStatistic whereDate($value)
 * @method static Builder|ContentStatistic whereId($value)
 * @method static Builder|ContentStatistic whereLangcode($value)
 * @method static Builder|ContentStatistic whereLikes($value)
 * @method static Builder|ContentStatistic whereSlug($value)
 * @method static Builder|ContentStatistic whereStatus($value)
 * @method static Builder|ContentStatistic whereTitle($value)
 * @method static Builder|ContentStatistic whereType($value)
 * @method static Builder|ContentStatistic whereUniqueVisits($value)
 * @method static Builder|ContentStatistic whereUpdatedAt($value)
 * @method static Builder|ContentStatistic whereUuid($value)
 * @method static Builder|ContentStatistic whereVisits($value)
 * @method static ContentStatistic orderBy($column, $direction = 'asc')
 * @method static Builder where($column, $operator = null, $value = null, $boolean = 'and')
 * @method static void truncate()
 * @method static static create(array $attributes = [])
 * @method static static firstOrCreate(array $attributes, array $values = [])
 * @mixin Collection
 */
class UserStatistic extends Model
{
    use WithEnhancedBuilder;

    /**
     * @var string
     */
    protected $table = 'user_statistics';

    /**
     * @var array
     */
    protected $casts = [
        'date' => 'timestamp',
    ];

    protected $fillable = [
        'uuid',
        'type',
        'date',
        'visits',
        'unique_visits',
    ];

    /**
     * @var bool
     */
    public $timestamps = false;

    /**
     * @return BelongsTo
     */
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'uuid');
    }

    public function users(): BelongsTo
    {
        return $this->belongsTo(Users::class, 'uuid');
    }
}
