<?php

namespace Inside\Statistics\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Inside\Database\Eloquent\WithEnhancedBuilder;

/**
 * @property int $id
 * @property int $likes
 * @property int $comments
 * @property int $date
 * @property int $news
 * @property int $memorandums
 * @property int $career_infos
 * @property int $p_and_p
 * @property int $lhg_events
 * @method static \Inside\Database\Eloquent\Builder|GlobalStatistic newModelQuery()
 * @method static \Inside\Database\Eloquent\Builder|GlobalStatistic newQuery()
 * @method static Builder query()
 * @method static Builder|GlobalStatistic whereCareerInfos($value)
 * @method static Builder|GlobalStatistic whereComments($value)
 * @method static Builder|GlobalStatistic whereId($value)
 * @method static Builder|GlobalStatistic whereLhgEvents($value)
 * @method static Builder|GlobalStatistic whereLikes($value)
 * @method static Builder|GlobalStatistic whereMemorandums($value)
 * @method static Builder|GlobalStatistic whereNews($value)
 * @method static Builder|GlobalStatistic wherePAndP($value)
 * @method static Builder|GlobalStatistic select(array|mixed $columns)
 * @method static Builder|GlobalStatistic selectRaw(string $expression, array $bindings = [])
 * @method static GlobalStatistic orderBy($column, $direction = 'asc')
 *
 * @mixin Collection
 */
class GlobalStatistic extends Model
{
    use WithEnhancedBuilder;

    /**
     * @var bool
     */
    public $timestamps = false;

    /**
     * @var string
     */
    protected $table = 'global_statistics';

    /**
     * @var array
     */
    protected $casts = [
        'date' => 'timestamp',
    ];
}
