<?php

namespace Inside\Statistics\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Inside\Content\Models\Content;
use Inside\Content\Models\Contents\Users;

/**
 * @method static insert($query, array $bindings = [])
 * @method static Builder|Statistic where($column, $operator = null, $value = null, $boolean = 'and')
 * @method static Builder|Statistic selectRaw(string $expression, array $bindings = [])
 */
class ContentStatistics extends Content
{
    protected $table = null;

    protected string $type = '';

    protected $fillable = [
        'user_uuid',
        'content_uuid',
        'date',
    ];

    protected function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
    }

    public static function bind(string $type): self
    {
        $statistic = new self();
        $statistic->setType($type);
        $statistic->setTable(type_to_stats_table($type));

        return $statistic;
    }

    public function newInstance($attributes = [], $exists = false)
    {
        $model = parent::newInstance($attributes, $exists);
        $model->setType($this->type);
        $model->setTable($this->table);

        return $model;
    }

    public function setType(string $type): void
    {
        $this->type = $type;
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(Users::class);
    }

    public function content(): BelongsTo
    {
        return $this->belongsTo(type_to_class($this->type));
    }

    public function scopeStartDate(Builder $query, string $date): Builder
    {
        return $query->where('date', '>=', $date);
    }

    public function scopeEndDate(Builder $query, string $date): Builder
    {
        return $query->where('date', '<=', $date);
    }

    protected static function boot()
    {
        parent::boot();
    }
}
