<?php

namespace Inside\Statistics\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Inside\Database\Eloquent\WithEnhancedBuilder;

/**
 * @property int $id
 * @property string $title
 * @property string $uuid
 * @property string $type
 * @property bool $status
 * @property string|null $slug
 * @property string|null $category_uuid
 * @property string|null $category_title
 * @property string|null $langcode
 * @property int $visits
 * @property int $unique_visits
 * @property int $likes
 * @property int $comments
 * @property int $created_at
 * @property int $updated_at
 * @property int $date
 * @method static \Inside\Database\Eloquent\Builder|ContentStatistic newModelQuery()
 * @method static \Inside\Database\Eloquent\Builder|ContentStatistic newQuery()
 * @method static \Inside\Database\Eloquent\Builder|ContentStatistic query()
 * @method static Builder|ContentStatistic whereCategoryTitle($value)
 * @method static Builder|ContentStatistic whereCategoryUuid($value)
 * @method static Builder|ContentStatistic whereComments($value)
 * @method static Builder|ContentStatistic whereCreatedAt($value)
 * @method static Builder|ContentStatistic whereDate($value)
 * @method static Builder|ContentStatistic whereId($value)
 * @method static Builder|ContentStatistic whereLangcode($value)
 * @method static Builder|ContentStatistic whereLikes($value)
 * @method static Builder|ContentStatistic whereSlug($value)
 * @method static Builder|ContentStatistic whereStatus($value)
 * @method static Builder|ContentStatistic whereTitle($value)
 * @method static Builder|ContentStatistic whereType($value)
 * @method static Builder|ContentStatistic whereUniqueVisits($value)
 * @method static Builder|ContentStatistic whereUpdatedAt($value)
 * @method static Builder|ContentStatistic whereUuid($value)
 * @method static Builder|ContentStatistic whereVisits($value)
 * @method static Builder from(\Closure|Builder|string $table, string|null $as = null)
 * @method static \Illuminate\Database\Query\Builder orderBy($column, $direction = 'asc')
 * @method static ContentStatistic create(array $attributes = [])
 * @method static void truncate()
 * @mixin Collection
 */
class ContentStatistic extends Model
{
    use WithEnhancedBuilder;

    /**
     * @var string
     */
    protected $table = 'content_statistics';

    /**
     * @var array
     */
    protected $guarded = [];

    /**
     * @var string[]
     */
    protected $casts = [
        'created_at' => 'timestamp',
        'updated_at' => 'timestamp',
        'published_at' => 'timestamp',
        'date' => 'timestamp',
        'status' => 'boolean',
    ];

    protected $dates = [
        'created_at',
        'updated_at',
        'published_at',
        'date',
    ];

    /**
     * @var bool
     */
    public $timestamps = false;
}
