<?php

namespace Inside\Statistics\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Inside\Authentication\Models\User;
use Inside\Content\Models\Content;

/**
 * @method static Builder|Statistic where($column, $operator = null, $value = null, $boolean = 'and')
 * @method static Builder|Statistic selectRaw(string $expression, array $bindings = [])
 * @method static \Inside\Database\Eloquent\Builder|Content query()
 */
class AuthenticationStatistics extends Content
{
    protected $table = 'inside_authentication_statistics';

    protected $primaryKey = ['user_uuid', 'created_at'];

    public $incrementing = false;

    public $timestamps = false;

    protected $fillable = ['user_uuid', 'created_at', 'connections'];

    protected $casts = [
        'created_at' => 'date',
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'user_uuid', 'uuid');
    }
}
